import { ChefHat, Phone, Mail, MapPin } from 'lucide-react'
import './Footer.css'

function Footer() {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <ChefHat className="footer-logo-icon" size={28} />
              <h2>КулинарМастер</h2>
            </div>
            <p className="footer-description">
              Откройте для себя мир кулинарии вместе с нашими профессиональными шеф-поварами. 
              Изучайте новые рецепты, техники и создавайте кулинарные шедевры.
            </p>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Темы мастер-классов</h3>
            <ul className="footer-links">
              <li><a href="/book">Выпечка</a></li>
              <li><a href="/book">Десерты</a></li>
              <li><a href="/book">Азиатская кухня</a></li>
              <li><a href="/book">Веганство</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone className="contact-icon" size={16} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail className="contact-icon" size={16} />
                <a href="mailto:info@culinarymaster.ru">info@culinarymaster.ru</a>
              </li>
              <li>
                <MapPin className="contact-icon" size={16} />
                <span>Москва, ул. Кулинарная, 15</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2024 КулинарМастер. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

